// src/pages/DashboardCoordinador.jsx
import React from "react";
import { useNavigate, Link } from "react-router-dom";
import Cookies from "js-cookie";
import { toast } from "react-hot-toast";
import uploadIcon from "../assets/upload-svgrepo-com.png";
import viewIcon from "../assets/view-svgrepo-com.png";
import userCogIcon from "../assets/user-cog-svgrepo-com.png";

// Componente reutilizable para botón rojo (igual que en Dashboard.jsx)
function RedButton({ children, onClick, type = "button", className = "" }) {
  return (
    <button
      type={type}
      onClick={onClick}
      className={`bg-red-600 hover:bg-red-700 text-white font-semibold py-2 px-4 rounded transition-colors duration-300 ${className}`}
    >
      {children}
    </button>
  );
}

export function DashboardCoordinador() {
  const navigate = useNavigate();
  const user = Cookies.get("user") ? JSON.parse(Cookies.get("user")) : null;
  const userID = Cookies.get("userId");

  const handleLogout = () => {
    Cookies.remove("token");
    Cookies.remove("user");
    toast.success("Sesión finalizada", { position: "top-center" });
    navigate("/login");
  };

  const IDNavigate = () => {
    navigate(`/Actualizar-contraseña/${userID}`);
  };

  return (
    <div className="flex flex-col min-h-screen bg-white">
      <header className="fixed top-0 left-0 right-0 z-50">
        <div className="flex w-full">
          {/* Sección de usuario */}
          <div className="bg-[#1572E8] text-white py-4 px-4 text-xl font-bold w-1/5 flex items-center space-x-4">
            <div>
              <h1 className="text-xl font-bold mb-4 ml-8">
                {user && user.nombre ? user.nombre : "Desconocido"}
              </h1>
              <p className="text-lg ml-8">{user ? user.rol : "Desconocido"}</p>
            </div>
          </div>

          {/* Sección de título + Botón "Cerrar sesión" */}
          <div className="bg-gradient-to-r from-[#00498B] to-[#001325] text-white py-8 px-8 text-xl font-bold w-4/5 flex justify-between items-center">
            <h1 className="text-xl font-semibold">SISTEMA DE PROYECCIÓN DE CURSOS</h1>
            <RedButton onClick={handleLogout}>Cerrar sesión</RedButton>
          </div>
        </div>
      </header>

      <main className="flex justify-center items-center flex-1 mt-20 px-10">
        <div className="bg-[#d7e9ff] p-10 rounded-lg max-w-4xl w-full">
          <div className="flex flex-wrap justify-center items-center gap-10">
            {/* Visualizar proyecciones */}
            <div className="flex flex-col items-center space-y-4">
              <img src={viewIcon} alt="Visualizar proyecciones" className="w-16 h-16" />
              <button
                onClick={() => navigate("/filtro-de-informacion")}
                className="bg-[#1572E8] px-4 py-2 rounded-lg text-white font-bold hover:bg-[#0f5fc7] transition-all duration-300"
              >
                Visualizar proyecciones
              </button>
            </div>

            {/* Actualizar contraseña */}
            <div className="flex flex-col items-center space-y-4">
              <img src={userCogIcon} alt="Actualizar contraseña" className="w-16 h-16" />
              <button
                onClick={IDNavigate}
                className="bg-[#1572E8] px-4 py-2 rounded-lg text-white font-bold hover:bg-[#0f5fc7] transition-all duration-300"
              >
                Actualizar contraseña
              </button>
            </div>
          </div>
        </div>
      </main>

      {/* Footer con tamaño igual al header */}
      <footer className="bg-gradient-to-r from-[#00498B] to-[#001325] text-white py-4 fixed bottom-0 left-0 right-0 z-50 flex items-center justify-center">
        <div className="text-center">
          <p>© 2025 Sistema de Proyección de Cursos</p>
          <p className="mt-1">Contacto: <a href="mailto:fredy.perez.i@uniautonoma.edu.co" className="hover:text-blue-300">fredy.perez.i@uniautonoma.edu.co</a><a href="mailto:juan.delgado.c@uniautonoma.edu.co" className="hover:text-blue-300"> - juan.delgado.c@uniautonoma.edu.co</a></p>

        </div>
      </footer>
    </div>
  );
}
